DEFLNG A-Z
'3d matrix rotation and pseudo-morph demo by Toshihiro Horie
'http://www.ocf.berkeley.edu/~horie/project.html
'I don't quite understand 3D matrix transformations
'but it seems to work.  Have fun with BASIC!
CONST pi! = 3.1415927#
DIM cosine(360), sine(360)
DIM P(1 TO 3)
DIM R(1 TO 3, 1 TO 3)
DIM ANG(1 TO 3)
k = 256
deg2rad! = pi! / 180

FOR A = 0 TO 359
    cosine(A) = INT(.5 + COS(A * deg2rad!) * k)
    sine(A) = INT(.5 + SIN(A * deg2rad!) * k)
NEXT

 ww = 1: vv = 0: SCREEN 9, , ww, vv
FOR zrot = 0 TO 359 STEP 2
FOR yrot = 0 TO 359 STEP 15
FOR xrot = 0 TO 359 STEP 60
    ANG(1) = xrot
    ANG(2) = yrot
    ANG(3) = zrot
    X = xrot \ 10: Y = ABS(sine(xrot)) \ 64: z = 6
    ca = cosine(ANG(1)): cb = cosine(ANG(2)): cc = cosine(ANG(3))
    sa = sine(ANG(1)): sb = sine(ANG(2)): ac = sine(ANG(3))
    'ROTATION MATRIX
    cacc = ca * cc
    casc = ca * sc
    R(1, 1) = cb * cc
    R(2, 1) = sb * cc + casc
    R(3, 1) = ca * sb - sasc
    R(1, 2) = cb * sc
    R(2, 2) = sa * sc + cacc
    R(3, 2) = ca * sb * sc - cacc
    R(1, 3) = -sb
    R(2, 3) = sa * cb
    R(3, 3) = ca * cb
    'CALCULATE ROTATED X,Y,Z
    FOR G = 1 TO 3
        P(G) = X * R(1, G) + Y * R(2, G) + z * R(3, G)
    NEXT
    'PRINT P(1) \ k, P(2) \ k, P(3) \ k

    'PROJECT TO 2D SCREEN - from Rich Geldreich's 3DEXP.BAS
    xx = P(1) \ k
    yy = P(2) \ k
    zz = P(3) \ k
    Mypos = 100: Spos = 85
    C1 = k
    S1 = 0
        xone = (xx * C1) \ 1024
        Y1 = yy
        X1 = xone
        Zn = xone \ k
        IF Zn = Mypos THEN GOTO skip:
      IF (Mypos - Zn) < 15 THEN
            Xn(R) = -1: Yn(R) = 0: Zn = 0
      ELSE
            'Put the point into perspective...
            v = (1330 * (Spos - Zn)) \ (Mypos - Zn)
            Xn = 320 + X1 + (-X1 * v) \ 1330
            Yn = 175 + (8 * (Y1 + (-Y1 * v) \ 1330)) \ 10
        IF zz < 0 THEN c = 14 ELSE c = 15
        LINE -(Xn, Yn), c
      END IF
skip:
NEXT xrot
'LOCATE 1, 1: PRINT xx, yy, zz
'LOCATE 2, 1: PRINT xrot, yrot, zrot
NEXT yrot
'page flip
SWAP ww, vv: SCREEN 9, , ww, vv:
WAIT &H3DA, 8: CLS : PRINT "3D Rotation demo by TH"
NEXT zrot
END

