DECLARE SUB rotate ()
DECLARE SUB loadplan ()
DECLARE SUB loadcube ()
DECLARE SUB putcube (xp AS INTEGER, yp AS INTEGER, nr AS INTEGER, shade AS INTEGER)
DECLARE SUB makepal ()
DECLARE SUB savecube (nr AS INTEGER)
DECLARE SUB init ()
DECLARE SUB plan ()
DECLARE SUB makecube ()
DECLARE SUB putspr (nr AS INTEGER)
DECLARE FUNCTION form$ (nr AS INTEGER)

CONST root = "c:\main\sprache\qb45\3d\"
CONST limx = 319, limy = 199
CONST fsz = 20
CONST fldx = 7, fldy = 3, fldz = 7
CONST cview = 6
CONST wave = 9
CONST cubemax = 6

TYPE sprite
 x AS INTEGER
 y AS INTEGER
 z AS INTEGER
END TYPE

DIM pic(1 TO cubemax, fsz, fsz) AS INTEGER
DIM cube(-fldx TO fldx, -fldy TO fldy, -fldz TO fldz) AS INTEGER
DIM camera AS sprite
DIM light AS sprite

SCREEN 13
RANDOMIZE TIMER
makepal
loadplan
loadcube

light.x = -2
light.y = 2
light.z = 0

DO
 CLS
 plan
 rotate
 SLEEP 10
LOOP

FUNCTION form$ (nr AS INTEGER)

form$ = LTRIM$(RTRIM$(STR$(nr)))

END FUNCTION

SUB loadcube

SHARED pic() AS INTEGER
DIM col AS INTEGER
DIM x AS INTEGER
DIM y AS INTEGER
DIM nr AS INTEGER

FOR nr = 1 TO cubemax

 OPEN root + form$(nr) + ".dat" FOR INPUT AS #1
 FOR x = 0 TO fsz
  FOR y = 0 TO fsz
   INPUT #1, pic(nr, x, y)
  NEXT
 NEXT
 CLOSE

NEXT

END SUB

SUB loadplan

SHARED cube() AS INTEGER

DIM nx AS INTEGER, ny AS INTEGER, nz AS INTEGER

OPEN root + "plan.dat" FOR INPUT AS #1
 FOR nx = -fldx TO fldx
  FOR ny = -fldy TO fldy
   FOR nz = -fldz TO fldz
    INPUT #1, cube(nx, ny, nz)
   NEXT
  NEXT
 NEXT
CLOSE #1

END SUB

SUB makepal

DIM nr AS INTEGER
DIM n AS INTEGER
DIM bl AS INTEGER, gr AS INTEGER, rd AS INTEGER

PALETTE 1, 2 ^ 16 * 63 + 2 ^ 8 * 63 + 63

n = wave / 2
FOR c1 = 0 TO 2
 FOR c2 = 0 TO 2
  FOR c3 = 0 TO 2
   FOR atbnr = 1 TO wave
    n = n + 1
    bl = (atbnr / (wave / (63 / 2))) * c1
    gr = (atbnr / (wave / (63 / 2))) * c2
    rd = (atbnr / (wave / (63 / 2))) * c3
    PALETTE n, 2 ^ 16 * bl + 2 ^ 8 * gr + rd
   NEXT
  NEXT
 NEXT
NEXT

END SUB

SUB plan

SHARED cube() AS INTEGER
SHARED camera AS sprite
DIM bx AS INTEGER
DIM xp AS INTEGER
DIM yp AS INTEGER
DIM xz AS INTEGER
DIM yz AS INTEGER

FOR xp = camera.x + cview TO camera.x - cview STEP -1
 FOR yp = camera.y - cview TO camera.y + cview STEP 1
  FOR zp = camera.z + cview TO camera.z - cview STEP -1
  
    IF xp + camera.x >= -fldx AND xp + camera.x <= fldx THEN
     IF yp + camera.y >= -fldy AND yp + camera.y <= fldy THEN
      IF zp + camera.z >= -fldz AND zp + camera.z <= fldz THEN
       
       bx = cube(xp + camera.x, yp + camera.y, zp + camera.z)
       xz = limx / 2 + xp * fsz - zp * (fsz / 2) - fsz / 2
       yz = limy / 2 + yp * fsz + zp * (fsz / 2) - fsz / 2
       IF bx <> 0 THEN putcube xz, yz, bx, (xp - yp + zp) / (cview + 1)
     
      END IF
     END IF
    END IF
  
  NEXT
 NEXT
NEXT

END SUB

SUB putcube (xp AS INTEGER, yp AS INTEGER, nr AS INTEGER, shade AS INTEGER)

SHARED pic() AS INTEGER
SHARED light AS sprite
DIM col AS INTEGER
DIM x AS INTEGER
DIM y AS INTEGER
DIM xx AS INTEGER
DIM yy AS INTEGER

FOR x = 0 TO fsz
 FOR y = 0 TO fsz
  
  col = pic(nr, x, y) + shade
 
  xx = xp + x
  yy = yp + y + fsz
  IF POINT(xx, yy) = 0 THEN PSET (xx, yy), col + light.x
 
  xx = xp + fsz / 2 + x - y / 2
  yy = yp + y / 2 + fsz / 2
  IF POINT(xx, yy) = 0 THEN PSET (xx, yy), col + light.y

  xx = xp + x / 2 + fsz
  yy = yp + fsz + y - x / 2
  IF POINT(xx, yy) = 0 THEN PSET (xx, yy), col + light.z

 NEXT
NEXT

END SUB

SUB rotate

SHARED cube() AS INTEGER
SHARED light AS sprite
DIM mcube(-fldx TO fldx, -fldy TO fldy, -fldz TO fldz) AS INTEGER
DIM nx AS INTEGER
DIM ny AS INTEGER
DIM nz AS INTEGER

FOR nx = -fldx TO fldx
 FOR ny = -fldy TO fldy
  FOR nz = -fldz TO fldz
   mcube(nx, ny, nz) = cube(-nx, ny, -nz)
  NEXT
 NEXT
NEXT

FOR nx = -fldx TO fldx
 FOR ny = -fldy TO fldy
  FOR nz = -fldz TO fldz
   cube(nx, ny, nz) = mcube(-nz, ny, nx)
  NEXT
 NEXT
NEXT

SWAP light.x, light.z

END SUB

